/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// And then further adapted to optimise it somewhat.  The improvement, while not
// huge, made a noticable difference with one of my more complex scenes. TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define time u_Elapsed

/////////////////////////////////////////////////////////////////////////////////

// HSV Lightning
// Modified by: Eivind Magnus Hvidevold and then by TheEmu
// hvidevold at gmail dot com
// By: Brandon Fogerty
// bfogerty at gmail dot com
// xdpixel.com

#ifdef GL_ES
precision mediump float;
#endif

// The original hsv2rgb, Hash and fbm functions replaced by macros so
// that the code is executed in line rather than via function  calls.
// This has improved the performance of the shader.

const vec3 hash_K    = vec3(37.1,61.7,12.4);
const vec3 hsv2rgb_K = vec3(1.0,2.0/3.0,1.0/3.0);

#define hsv2rgb(c) ( mix(vec3(1.0),abs(fract(c.xxx+hsv2rgb_K)*6.0-3.0)-1.0,c.y)*c.z )
#define hash(p)    ( fract(sin(dot(vec3(p.xy,1.0),hash_K))*3758.5453123) )
#define fbm(p)     ( noise(p)*0.500 + noise(p*2.0)*0.250 + noise(p*4.0)*0.125 )

// Noise left as a function because it would be an unwieldy as a macro.

float noise ( in vec2 p )
{
  vec2 i00 = floor(p);
  vec2 i01 = vec2(i00.x,i00.y+1.0);
  vec2 i10 = vec2(i00.x+1.0,i00.y);
  vec2 i11 = vec2(i10.x,i01.y);

  vec2 f = fract(p);
  f *= f * (3.0-2.0*f);

  return mix ( mix ( hash(i00), hash(i10), f.x ),
               mix ( hash(i01), hash(i11), f.x ),
               f.y );
}

void main( void )
{
   // Shift origin and rescale pixel position.

   vec2 uv = ( gl_FragCoord.xy / u_WindowSize.xy ) * 2.0 - 1.0;
   uv.x *= u_WindowSize.x/u_WindowSize.y;

   // The lightning is only in the low x side so quit early
   // if we are not in that side to avoid unnecessary work.

   if ( uv.x < -1.0 || uv.x > 0.0 ) { gl_FragColor = vec4(0.0); return; }

   // Get the thickness for the lightning.

   float thickness = mix ( 0.7, 1.0, noise(uv*10.0) );

   // Determine the colour for the current pixel.  This used
   // to be a for loop but its been unrolled and rearranged.
 
   vec2 c1 = 25.0 * sin ( uv + fbm(time*0.5+uv) );
   vec2 c2 = 30.0 * sin ( uv + fbm(time*1.5+uv) );
   vec2 c3 = 35.0 * sin ( uv + fbm(time*2.5+uv) );

   vec3 colour = abs(thickness/c1.x) * hsv2rgb ( vec3(c1.y*0.02,1.0,1.0) )
               + abs(thickness/c2.x) * hsv2rgb ( vec3(c2.y*0.02,1.0,1.0) )
               + abs(thickness/c3.x) * hsv2rgb ( vec3(c3.y*0.02,1.0,1.0) );

   // Set the pixel's colour.

   gl_FragColor = vec4 ( colour, length(colour) );

}
